/*****************************************************************************
*  LPC15xx SCT demoprogram for MicroCore100 rev A board
*
*  1. Use SCT3 timer to generate a PWM output signal @ SCT3_OUT0
*  2. Every time P2_5 (S2) goes high to low increase the duty cycle.
*  3. Every time P2_4 (S3) goes high to low decrease the duty cycle.
*****************************************************************************/
#include "LPC15xx.h"

extern void SCT3_Init(void);

int main (void) 
{
  static uint8_t trg1 = 1;
  static uint8_t trg2 = 1;

    LPC_SYSCON->SYSAHBCLKCTRL0 |= (1 << 16);                   // enable clock to GPIO port 2
    LPC_SWM->PINASSIGN9 |= 0x00FF0000;                         // ASSIGN9(23:16) = FF
    LPC_SWM->PINASSIGN9 &= 0xFF07FFFF;                         // P0_7 is SCT3_OUT0, ASSIGN9(23:16)
    SCT3_Init();                                               // Initialize SCT3

    while (1)                                                  // loop forever
    {
        if (!(LPC_GPIO->PIN[2] & (1 << 5)) && trg1)            // P2_5 high to low?
        {
            trg1 = 0;                                          // trigger P2_5 low
            if (LPC_SCT3->MATCHREL[1].L < 19)
                LPC_SCT3->MATCHREL[1].L ++;                    // increase PWM dutycycle
        }
        else if ((LPC_GPIO->PIN[2] & (1 << 5)) && !trg1)       // P2_5 low to high?
        {
            trg1 = 1;                                          // trigger P2_5 high
        }

        if (!(LPC_GPIO->PIN[2] & (1 << 4)) && trg2)            // P2_4 high to low?
        {
            trg2 = 0;                                          // trigger P2_4 low
            if (LPC_SCT3->MATCHREL[1].L > 0)
                LPC_SCT3->MATCHREL[1].L --;                    // decrease PWM dutycycle
        }
        else if ((LPC_GPIO->PIN[2] & (1 << 4)) && !trg2)       // P2_4 low to high?
        {
            trg2 = 1;                                          // trigger P2_4 high
        }
    }
}
